	% Box 15.3
	clear all, close all, clc
	wcT = 0.25*pi;	wsT = 0.3*pi; dc = 0.01; ds = 0.001;  
	figure(1)
	wT = linspace(0, pi, 1000);
	[N, Be, D, W] = L_PHASE_LP_FIR_ORDER([wcT wsT], [dc ds]);
	N
	[h0, Err] = REMEZ_FIR(N,Be,D, W,'m');
	H0 = freqz(h0,1,wT); PLOT_MAG_Z_dB(wT, H0, pi, 80, 'H_0')
%	Amax = H_2_MAG((1+dc)/(1-dc))
%	Amin = H_2_MAG((1+dc)/ds)
	hold on
	zoom on

	M = 2;
	[N, Be, D, W] = L_PHASE_LP_FIR_ORDER(M*[wcT wsT], [dc/2 ds]);
	N
	[hK, Err] = REMEZ_FIR(N,Be,D, W, 'm');
	HK = freqz(hK,1,M*wT);
	subplot(2,1,1), PLOT_MAG_Z_dB(wT, HK, pi, 80, 'H_K'), hold on
	Norder = 10;

	[hD, Err] = L_PHASE_LP_HB_FIR(Norder, pi-wcT)
	HD = freqz(hD,1,wT); PLOT_MAG_Z_dB(wT, HD, pi, 80, 'H_D')
	hI = hD; % Interpolation filter  
	HI = freqz(hI,1,wT); PLOT_MAG_Z_dB(wT, HI, pi, 80, 'H_D|, |H_I')	
	H = HD.*HK.*HI;
	subplot(2,1,2), PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	Amax = max(H_2_MAG(H(1:250)))-min(H_2_MAG(H(1:250)))
	Amin = -max(H_2_MAG(H(301:end)))
	zoom on
	
	% Aliasing
	figure(2)
	wT = linspace(0,pi,1000); 
	 HI = freqz(hD, 1, wT);
	subplot('position', [0.1 0.4 0.88 0.5]);
	for k = 1:M-1
		D = -2*pi*k/M;
		H = HK.*HI.*freqz(hD,1, wT+D);
		PLOT_MAG_Z_dB(wT, H, pi, 120, '-')
		hold on
	end
